<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class DependantChildAttribute implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private string $type,
        private bool $isSystemRequired,
        private string $parent
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function isSystemRequired(): bool
    {
        return $this->isSystemRequired;
    }

    public function getParent(): string
    {
        return $this->parent;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getType(): string
    {
        return $this->type;
    }
}
