<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class ObjectType implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private ?string $icon,
        private ?string $constant,
        private ?string $color,
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function getConstant(): ?string
    {
        return $this->constant;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function __toString(): string
    {
        return json_encode($this->jsonSerialize(), JSON_PRETTY_PRINT);
    }
}
