<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Component\Download\DownloadType;
use idoit\Component\FeatureManager\FeatureManager;
use idoit\Component\Upload\UploadType;
use idoit\Module\SyneticsJdisc\Model\LogsDao;
use idoit\Module\SyneticsJdisc\Upload\JDiscProfiles;
use idoit\Psr4AutoloaderClass;

Autoloader::appendClassmap(include(__DIR__ . '/classmap.php'));

if (isys_module_manager::instance()->is_active('synetics_jdisc')) {
    require __DIR__ . '/vendor/autoload.php';

    isys_register::factory('additional-dialog-admin-tables')
        ->set('isys_jdisc_status_list');

    Psr4AutoloaderClass::factory()
        ->addNamespace('idoit\Module\SyneticsJdisc', __DIR__ . '/src/')
        ->addNamespace('idoit\Module\Synetics_jdisc', __DIR__ . '/src/');

    $jdiscModule = new isys_module_synetics_jdisc();

    isys_application::instance()->container->get('signals')
        ->connect('mod.cmdb.objectDeleted', [$jdiscModule, 'clearMapping'])
        ->connect('mod.cmdb.afterObjectTypeSave', [$jdiscModule, 'slot_after_obj_type_save'])
        ->connect('mod.cmdb.viewProcessed', [$jdiscModule, 'slot_view_proceessed']);

    // Add report views.
    isys_register::factory('additional-report-views')
        ->set(__DIR__ . '/reportview/isys_report_view_jdisc_availability.class.php')
        ->set(__DIR__ . '/reportview/isys_report_view_jdisc_delete_devices.class.php');

    isys_application::instance()->container->get('upload')
        ->registerUploadType('jdisc.profiles-import', (new UploadType())->setUploadDirectory('/temp/')
            ->setValidExtensions(['json'])
            ->setSizeLimit(16777216) // 16 MB
            ->setCallbackAfterUpload([JDiscProfiles::class, 'processUpload']));

    isys_application::instance()->container->get('download')
        ->registerDownloadType('jdisc.log-file', new DownloadType([LogsDao::class, 'getDownloadPath']));

    if (FeatureManager::isFeatureActive('jdisc-settings')) {
        // add new JDisc tenant settings
        isys_application::instance()->container->get('settingsTenant')
            ->extend([
                'LC__MODULE__JDISC' => [
                    // archive settings
                    'jdisc.threshold'                    => [
                        'title'       => 'LC__SETTINGS__JDISC__THRESHOLD',
                        'type'        => 'int',
                        'placeholder' => 30,
                        'default'     => 0,
                        'description' => 'LC__SETTINGS__JDISC__THRESHOLD__DESCRIPTION'
                    ],
                    'jdisc.threshold_type'               => [
                        'title'   => 'LC__SETTINGS__JDISC__THRESHOLD_TYPE',
                        'type'    => 'select',
                        'default' => 'LC__UNIVERSAL__DAYS',
                        'options' => [
                            'days'   => 'LC__UNIVERSAL__DAYS',
                            'weeks'  => 'LC__UNIVERSAL__WEEKS',
                            'months' => 'LC__UNIVERSAL__MONTHS'
                        ],
                    ],
                    // pause settings
                    'jdisc.max_pause_time_before_action' => [
                        'title'       => 'LC__SETTINGS__JDISC__MAX_PAUSE',
                        'type'        => 'int',
                        'placeholder' => 15,
                        'default'     => 15,
                        'description' => 'LC__SETTINGS__JDISC__MAX_PAUSE__DESCRIPTION'
                    ],
                    'jdisc.after_pause_action'           => [
                        'title'   => 'LC__SETTINGS__JDISC__AFTER_PAUSE_ACTION',
                        'type'    => 'select',
                        'default' => 'cancel',
                        'options' => [
                            'cancel'   => 'LC__UNIVERSAL__BUTTON_CANCEL',
                            'continue' => 'LC__UNIVERSAL__BUTTON_CONTINUE',
                        ],
                    ],
                ]
            ]);
    }
}
