<?php

namespace idoit\Module\SyneticsJdisc;

use isys_application;
use isys_auth;
use isys_auth_dao;
use isys_auth_interface;

class Auth extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance.
     *
     * @var  Auth
     */
    private static $instance;

    public function get_auth_methods()
    {
        return [
            'dashboard' => [
                'title'   => 'LC__JDISC__TREE__DASHBOARD',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::EXECUTE],
                'default' => [isys_auth::VIEW],
            ],
            'device-list' => [
                'title'   => 'LC__JDISC__TREE__DEVICE_LIST',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::EXECUTE],
                'default' => [isys_auth::VIEW],
            ],
            'sync-profiles' => [
                'title'   => 'LC__JDISC__TREE__SYNC_PROFILES',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE, isys_auth::SUPERVISOR],
                'default' => [isys_auth::VIEW],
            ],
            'discovery-server' => [
                'title'   => 'LC__JDISC__TREE__DISCOVERY_SERVER',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE, isys_auth::SUPERVISOR],
                'default' => [isys_auth::VIEW],
            ],
            'logs' => [
                'title'   => 'LC__JDISC__TREE__LOGS',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW],
                'default' => [isys_auth::VIEW],
            ],
        ];
    }

    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$instance === null) {
            self::$instance = new self;
        }

        return self::$instance;
    }

    /**
     * Get ID of related module.
     *
     * @return  integer
     */
    public function get_module_id()
    {
        return defined_or_default('C__MODULE__JDISC');
    }

    /**
     * Get title of related module.
     *
     * @return  string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__JDISC';
    }
}
