<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type ApplicationInstanceInput
 * The applications installed on an operating system. * @property null|ApplicationInputInputType $application = null The application that is providing this instance
 * @property null|string $applicationInstallPath = null The installation path for the application that this instance belongs to.
 * @property null|iterable|DatabaseInputInputType[] $databases = null The list of databases for this instance
 * @property null|string $instancePath = null The instance path (if it exists).
 * @property null|string $name = null The application instance name
 * @property null|OperatingSystemInputInputType $operatingSystem = null The operating system that the instance is installed on
 * @property null|iterable|PortConnectionInputInputType[] $ports = null Ports that this application instance is listening on
 * @property null|SoftwareInstanceStateEnum $state = null The application that is providing this instance
 * @property null|SoftwareInstanceTypeEnum $type = null The application instance type
 */
final class ApplicationInstanceInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'application') {
            return new ApplicationInputInputType($value);
        }

        if ($name === 'databases') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new DatabaseInputInputType($v)); })($value);
        }

        if ($name === 'operatingSystem') {
            return new OperatingSystemInputInputType($value);
        }

        if ($name === 'ports') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new PortConnectionInputInputType($v)); })($value);
        }

        if ($name === 'state') {
            return new SoftwareInstanceStateEnum($value);
        }

        if ($name === 'type') {
            return new SoftwareInstanceTypeEnum($value);
        }

        return $value;
    }
}