<?php

use idoit\Component\FeatureManager\FeatureCheckInterface;
use idoit\Component\FeatureManager\FeatureManager;
use idoit\Component\Property\Type\CommentaryProperty;
use idoit\Component\Property\Type\DateProperty;
use idoit\Component\Property\Type\TextProperty;

class isys_cmdb_dao_category_g_jdisc_device_information extends isys_cmdb_dao_category_global implements FeatureCheckInterface
{
    /**
     * Category's name. Will be used for the identifier, constant, main table, and many more.
     *
     * @var  string
     */
    protected $m_category = 'jdisc_device_information';
    /**
     * Category entry is purgable
     *
     * @var  boolean
     */
    protected $m_is_purgable = false;
    /**
     * Is category multi-valued or single-valued?
     *
     * @var  boolean
     */
    protected $m_multivalued = false;
    /**
     * Method for returning the properties.
     *
     * @return  array
     * @author  Van Quyen Hoang <qhoang@i-doit.org>
     */
    protected function properties()
    {
        return [
            'importDate'     => (
            new DateProperty(
                'C__CATG__JDISC_DEVICE_INFORMATION__IMPORT_DATE',
                'LC__CMDB__CATG__JDISC_DEVICE_INFORMATION__IMPORT_DATE',
                'isys_catg_jdisc_device_information_list__import_date',
                'isys_catg_jdisc_device_information_list',
                true
            )
            )->mergePropertyUiParams(['p_bDisabled' => true])
                ->mergePropertyProvides([
                    C__PROPERTY__PROVIDES__MULTIEDIT => false
                ]),
            'lastSeen'       => (
            new DateProperty(
                'C__CATG__JDISC_DEVICE_INFORMATION__LAST_SEEN',
                'LC__CMDB__CATG__JDISC_DEVICE_INFORMATION__LAST_SEEN',
                'isys_catg_jdisc_device_information_list__last_seen',
                'isys_catg_jdisc_device_information_list',
                true
            ))->mergePropertyUiParams(['p_bDisabled' => true])
                ->mergePropertyProvides([
                    C__PROPERTY__PROVIDES__MULTIEDIT => false
                ]),
            'lastDiscovered' => (
            new DateProperty(
                'C__CATG__JDISC_DEVICE_INFORMATION__LAST_DISCOVERED',
                'LC__CMDB__CATG__JDISC_DEVICE_INFORMATION__LAST_DISCOVERED',
                'isys_catg_jdisc_device_information_list__last_discovered',
                'isys_catg_jdisc_device_information_list',
                true
            ))->mergePropertyUiParams(['p_bDisabled' => true])
                ->mergePropertyProvides([
                    C__PROPERTY__PROVIDES__MULTIEDIT => false
                ]),
            'uniqueId' => (new TextProperty(
                'C__CATG__JDISC_DEVICE_INFORMATION__UNIQUE_ID',
                'LC__CMDB__CATG__JDISC_DEVICE_INFORMATION__UNIQUE_ID',
                'isys_catg_jdisc_device_information_list__unique_id',
                'isys_catg_jdisc_device_information_list'
            )),
            'description' => (new CommentaryProperty(
                'C__CMDB__CAT__COMMENTARY_' . C__CMDB__CATEGORY__TYPE_GLOBAL . C__CATG__JDISC_DEVICE_INFORMATION,
                'isys_catg_jdisc_device_information_list__description',
                'isys_catg_jdisc_device_information_list'
            )),
        ];
    }

    /**
     * @param string $uniqueId
     *
     * @return array|null
     */
    public function getIdentifierDataByUniqueId(string $uniqueId): ?array
    {
        return $this->retrieve(
            <<<SQL
            SELECT DISTINCT
                isys_catg_jdisc_device_information_list__id AS id,
                isys_catg_jdisc_device_information_list__isys_obj__id AS objectId
            FROM isys_catg_jdisc_device_information_list
            WHERE isys_catg_jdisc_device_information_list__unique_id = {$this->convert_sql_text($uniqueId)}
            LIMIT 1
            SQL
        )->get_row();
    }

    /**
     * @return bool
     */
    public static function isFeatureEnabled(): bool
    {
        return FeatureManager::isFeatureActive('jdisc-category');
    }
}
