<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsJdisc\Controller;

use GuzzleHttp\Psr7\Exception\MalformedUriException;
use Symfony\Component\HttpFoundation\Request;

class BaseController
{
    /**
     * @param Request $request
     *
     * @return array
     */
    protected function extractData(Request $request): array
    {
        $content = $request->getContent();

        if (!is_string($content)) {
            throw new MalformedUriException('Malformed JSON string');
        }
        return json_decode($content, true);
    }
}
