<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Mutation;

use GraphQL\Mutation;
use GraphQL\Query;
use GraphQL\RawObject;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Schema\Model\DeviceDeletionTypeEnum;

// example:
//
// $connector = Connector::instance($serverId);
// $connector->connect();
// $query = new DeleteDevice();
// $query->setId(1000);
// $deleted = $connector->query($query);

class DeleteDevice extends AbstractGraphql implements ResponseInterface
{
    private int $id;

    private string $comment = 'Deleted by i-doit';

    private array $selections = [];

    /**
     * @param int $id
     *
     * @return $this
     */
    public function setId(int $id): self
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @param string $comment
     *
     * @return $this
     */
    public function setComment(string $comment): self
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return array
     */
    public function getParameters(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return $this->selections;
    }


    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['management']['devices'];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Mutation('management'))
            ->setSelectionSet([
                (new Query('devices'))
                    ->setSelectionSet([
                        (new Query('deleteDevice'))
                            ->setArguments([
                                'deviceRef'    => new RawObject("{id: $this->id}"),
                                'comment'      => $this->comment,
                                'deletionType' => new DeviceDeletionTypeEnum('NoFilter'),
                            ])
                            ->setSelectionSet($this->getSelections())
                ])
            ]);
    }
}
