<?php

namespace idoit\Module\SyneticsJdisc\Graphql\Query;

use GraphQL\Query;
use GraphQL\RawObject;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;

// example:
//
// $connector = Connector::instance($serverId);
// $connector->connect();
// $query = new DeviceListColumns();
// $data = $connector->query($query);

class DeviceListColumns extends AbstractGraphql implements ResponseInterface
{
    /**
     * @return array
     */
    public function getParameters(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getSelections(): array
    {
        return [];
    }


    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        $columns = [];
        foreach ($data['reporting']['tableData']['reportDescription']['columns'] as $column) {
            $columns[$column['fieldDescription']['fieldId']] = [
                'name' => $column['fieldDescription']['columnHeader'],
            ];
        }
        return $columns;
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query())->setSelectionSet([
            (new Query('reporting'))->setSelectionSet([
                (new Query('tableData'))
                    ->setArguments([
                        'reportConfig' => new RawObject(
                            <<<reportConfig
                            {
                                builtInReport: DEVICE_REPORT_ID,
                                type: Table
                            }
                            reportConfig
                        )
                    ])
                    ->setSelectionSet([
                        (new Query('reportDescription'))
                            ->setSelectionSet([
                                (new Query('columns'))
                                    ->setSelectionSet([
                                        (new Query('fieldDescription'))
                                            ->setSelectionSet([
                                                'fieldId',
                                                'columnHeader',
                                            ]),
                                    ])
                            ]),
                    ])
            ]),
        ]);
    }
}
