<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type ScheduledReportingMutation
 * Mutation operations for scheduled reporting */
final class ScheduledReportingMutationType implements AutoGenerationInterface
{
    /**
     * Adds a scheduled report mail export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $addMailExportJob;
    /**
     * Adds a scheduled report network export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $addNetworkExportJob;
    /**
     * Adds a network storage location. Returns the id of the created location

Required permissions: ManageNetworkLocations, ScheduleReports
     */
    public $addNetworkStorageLocation = null;
    /**
     * Changes a scheduled report mail export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $changeMailExportJob;
    /**
     * Changes the scheduled report mail export job owner. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $changeMailExportJobOwner;
    /**
     * Changes a scheduled report network export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $changeNetworkExportJob;
    /**
     * Changes the scheduled report network export job owner. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $changeNetworkExportJobOwner;
    /**
     * Deletes the given scheduled report mail export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $deleteMailExportJob;
    /**
     * Deletes the given scheduled report mail export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $deleteMailExportJobs;
    /**
     * Deletes given mail recipients. Returns true when deletions were successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs, ManageScheduledMailReportJobs
     */
    public bool $deleteMailRecipients;
    /**
     * Deletes the given scheduled report network export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $deleteNetworkExportJob;
    /**
     * Deletes the given scheduled report network export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $deleteNetworkExportJobs;
    /**
     * Deletes a network storage location. Returns the id of the deleted location

Required permissions: ManageNetworkLocations, ScheduleReports
     */
    public $deleteNetworkStorageLocation = null;
    /**
     * Runs a scheduled report mail export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledMailReportJobs
     */
    public bool $runMailExportJob;
    /**
     * Runs a scheduled report network export job. Returns true when successful, otherwise false 

Required permissions: ManageScheduledReportExportJobs
     */
    public bool $runNetworkExportJob;
    /**
     * Test a network storage location. Returns the test result status

Required permissions: ManageNetworkLocations, ScheduleReports
     */
    public ?DiscoveryProtocolStatusType $testNetworkStorageLocation = null;
    /**
     * Update a network storage location. Returns true if update was successful

Required permissions: ManageNetworkLocations, ScheduleReports
     */
    public bool $updateNetworkStorageLocation;
}